# ----------------------------------------------------------------------------------------------
# Copyright (c) WCOM AB 2016.
# ----------------------------------------------------------------------------------------------
# This source code is subject to terms and conditions of the The MIT License (MIT)
# copy of the license can be found in the LICENSE file at the root of this distribution.
# ----------------------------------------------------------------------------------------------
# You must not remove this notice, or any other, from this software.
# ----------------------------------------------------------------------------------------------
Param(
    $SlackWebHook,
    $SlackChannel,
    $SiteName,
    $Device,
    $Name,
    $Status,
    $Down,
    $DateTime,
    $LinkDevice,
    $Message,
    $Color
)
$StatusIcon
$SlackTextFormatting


$StatusIcon = ':admission_tickets:'


Add-Type -AssemblyName System.Web.Extensions
function ConvertTo-Json ([Object] $value)
{
    [System.Web.Script.Serialization.JavaScriptSerializer] $jsSerializer = New-Object 'System.Web.Script.Serialization.JavaScriptSerializer'
    $jsSerializer.Serialize($value)
}

$postSlackMessage = "
{
    ""channel"": ""$SlackChannel"",
    ""unfurl_links"": false,
    ""username"": ""HelpDesk"",
    ""icon_url"": ""https://helpdesk.CHANGETHISURL.com/helpdesk/favicon.ico"",
    ""attachments"": [{
        ""title"": ""$Device - $SlackTextFormatting$($Name)"",
        ""title_link"": ""$LinkDevice"",
        ""color"": ""warning"",
        ""pretext"": """",
        ""text"": ""``````$($Message)``````"",
        ""mrkdwn_in"": [
            ""text"",
            ""pretext""
        ],
    }],
}
"

write-host $postSlackMessage
$postSlackMessage | Out-File -FilePath slack.log

[System.Net.WebClient] $webclient = New-Object 'System.Net.WebClient'
    
    $DT = Date
    "$DT|$Device|Start Processing" | Add-Content SlackLog.txt

try {

    $error = $webclient.UploadData($SlackWebHook, [System.Text.Encoding]::UTF8.GetBytes($postSlackMessage)) | Out-File -FilePath slack.log -Append 
} catch {
    $DT = Date
    "$DT|$Device|error" | Add-Content SlackLog.txt
    "
`r`n
=========================================================================================================`r`n
$DT|$Device`r`n
=========================================================================================================`r`n
$error
=========================================================================================================`r`n

" | Add-Content SlackLogErrorDetails.txt
}
    $DT = Date
    "$DT|$Device|End Processing" | Add-Content SlackLog.txt
