$MyServer = "127.0.0.1"
$MyPort  = "20293"
$MyDB = "whd"
$MyUid = "whd"
$MyPass = "whd"

$entry_age_minutes = 32

Function SlackCleanUp($var)
{
 $var = $var.Replace("""","")
 $var = $var.Replace("'","")
 $var = $var.Replace("\","-")
 $var = $var.Replace("{","-")
 $var = $var.Replace("}","-")
 return $var
}

$SQL = "
SELECT 
JT.job_ticket_id,JT.subject,JT.question_text,
C.first_name, C.last_name, C.email, C.phone,
HE.HistoryEntry, HE.HistoryDate,HE.HistoryText,
TE.first_name AS TEFirstName, TE.last_name AS TELastName, TE.phone_3 AS TESlack,
POT.problem_type_name,PIT.priority_type_name

FROM job_ticket JT
LEFT JOIN client AS C ON C.client_id = JT.client_ID
LEFT JOIN tech AS TE ON TE.client_id = JT.assigned_tech_id
LEFT JOIN (SELECT job_ticket_id,max(id) AS HistoryID,max(entry_text) AS HistoryEntry,max(entry_date) AS HistoryDate,max(type) AS HistoryType,max(detail_text) AS HistoryText FROM history_entry WHERE type = 6 GROUP BY job_ticket_id ORDER BY job_ticket_id DESC) AS HE ON HE.job_ticket_id = JT.job_ticket_id
LEFT JOIN public.problem_type AS POT ON POT.problem_type_id = JT.problem_type_id
LEFT JOIN public.priority_type AS PIT ON PIT.priority_type_id = JT.priority_type_id
WHERE HE.HistoryType = 6 -- 6 = new Client Note
AND JT.close_date IS NULL
AND JT.deleted <> 1
AND (((DATE_PART('day', HistoryDate - current_timestamp) * 24 + 
 DATE_PART('hour', HistoryDate - current_timestamp)) * 60 +
 DATE_PART('minute', HistoryDate - current_timestamp))*-1) < $entry_age_minutes
AND (SELECT count(job_ticket_id) FROM history_entry WHERE job_ticket_id = HE.job_ticket_id AND entry_date > HE.HistoryDate AND type = 5 AND tech_id = TE.client_id)=0
ORDER BY JT.job_ticket_id DESC,HE.HistoryID DESC 
LIMIT 100
"

$con = New-Object -ComObject ADODB.Connection
$rs = New-Object -ComObject ADODB.Recordset

$con.Open("Driver={PostgreSQL UNICODE(x64)};Server=$MyServer;Port=$MyPort;Database=$MyDB;Uid=$MyUid;Pwd=$MyPass;")

$rs.Open($SQL, $con, 3, 3)
    If ($rs.EOF -ne $True)
    {
        $rs.MoveFirst()
        While ($rs.EOF -ne $True)
        {
                Write-Host "Ticket Nr.:" $rs.Fields.Item("job_ticket_id").Value
                Write-Host "  Subject:" $rs.Fields.Item("subject").Value
                Write-Host "  Client Name:" $rs.Fields.Item("first_name").Value $rs.Fields.Item("last_name").Value
                Write-Host "  Client eMail:" $rs.Fields.Item("email").Value
                Write-Host "  Client Phone:" $rs.Fields.Item("phone").Value
                Write-Host "  Tech Name:" $rs.Fields.Item("TEFirstName").Value $rs.Fields.Item("TEFirstName").Value
                Write-Host "  Problem Type:" $rs.Fields.Item("problem_type_name").Value
                Write-Host "  Priority:" $rs.Fields.Item("priority_type_name").Value
                Write-Host "  Slack User:" $rs.Fields.Item("TESlack").Value
                Write-Host "  History Date: " $rs.Fields.Item("HistoryDate").Value
                Write-Host "  History Text: " $rs.Fields.Item("HistoryEntry").Value

                $DT = Date
                "$DT" + "|" + $rs.Fields.Item("job_ticket_id").Value + "|" + $rs.Fields.Item("TESlack").Value | Add-Content ClientNoteTicketLog.txt

                $subject = ":memo: NEW CLIENT NOTE - " + $rs.Fields.Item("subject").Value 
                $subject = SlackCleanup($subject)

                $ticket = $rs.Fields.Item("job_ticket_id").Value
                $ticketlink = "https://helpdesk.YourHelpdeskURL.com/helpdesk/WebObjects/Helpdesk.woa/wa/TicketActions/view?ticket=$ticket"

                $RequestDetail = $rs.Fields.Item("HistoryText").Value
                $RequestDetail = $RequestDetail.Trim()
                $RequestDetailLength = $RequestDetail.Length
                If ($RequestDetailLength -gt 500)
                {
                    $RequestDetailLength = 500
                }
                $RequestDetail = $RequestDetail.Substring(0,$RequestDetailLength)
                $RequestDetail = SlackCleanup($RequestDetail)

                $TicketDetails = "
Tech Name:        " + $rs.Fields.Item("TEFirstName").Value + " " + $rs.Fields.Item("TEFirstName").Value + " @" + $rs.Fields.Item("TESlack").Value  + "
Client Name:      " + $rs.Fields.Item("first_name").Value + " " + $rs.Fields.Item("last_name").Value + "
Request Type:     " + $rs.Fields.Item("problem_type_name").Value + "
Priority:         " + $rs.Fields.Item("priority_type_name").Value + "
Client eMail:     " + $rs.Fields.Item("email").Value + "
Client Phone:     " + $rs.Fields.Item("phone").Value + "
Request Detail:   " + $RequestDetail

$channel = "@" + $rs.Fields.Item("TESlack").Value

				.\PRTGSlackWebHookNotificationPSv2.ps1 -SlackWebHook 'https://hooks.slack.com/services/YourWebHookURL' -SlackChannel $channel -SiteName 'HelpDesk' -Device $ticket -Name $subject -Status 'status' -Down 'down' -DateTime 'datetime' -LinkDevice $ticketlink -Message $TicketDetails -Color 'colorofstate'

            $rs.MoveNext();
        }
    }

$rs.Close()
$con.Close()

