$MyServer = "127.0.0.1"
$MyPort  = "20293"
$MyDB = "whd"
$MyUid = "whd"
$MyPass = "whd"

$ticket_age_minutes = 88

$channel = '#helpdesk'


Function SlackCleanUp($var)
{
 $var = $var.Replace("""","")
 $var = $var.Replace("'","")
 $var = $var.Replace("\","-")
 $var = $var.Replace("{","-")
 $var = $var.Replace("}","-")
 return $var
}

$SQL = "
SELECT 
job_ticket_id,subject,(report_date AT Time Zone 'US/Pacific') AS open_date, 
(((DATE_PART('day', report_date - current_timestamp) * 24 + 
 DATE_PART('hour', report_date - current_timestamp)) * 60 +
 DATE_PART('minute', report_date - current_timestamp))*-1) AS open_for_minutes,
first_response_date,close_date,
T.client_id, C.first_name, C.last_name, C.email, C.phone,
assigned_tech_id, E.first_name AS tech_first_name, E.last_name as tech_last_name,
problem_type_name,priority_type_name, E.phone_3, question_text
FROM public.job_ticket AS T
LEFT JOIN public.client AS C ON C.client_id = T.client_ID
LEFT JOIN public.tech AS E ON E.client_id = T.assigned_tech_id
LEFT JOIN public.problem_type AS P ON P.problem_type_id = T.problem_type_id
LEFT JOIN public.priority_type AS I ON I.priority_type_id = T.priority_type_id
WHERE close_date IS NULL
AND first_response_date IS NULL
AND T.deleted <> 1
AND (((DATE_PART('day', report_date - current_timestamp) * 24 + 
 DATE_PART('hour', report_date - current_timestamp)) * 60 +
 DATE_PART('minute', report_date - current_timestamp))*-1) > $ticket_age_minutes
ORDER BY job_ticket_id
DESC LIMIT 100
"

$con = New-Object -ComObject ADODB.Connection
$rs = New-Object -ComObject ADODB.Recordset

$con.Open("Driver={PostgreSQL UNICODE(x64)};Server=$MyServer;Port=$MyPort;Database=$MyDB;Uid=$MyUid;Pwd=$MyPass;")

$rs.Open($SQL, $con, 3, 3)
    If ($rs.EOF -ne $True)
    {
        $rs.MoveFirst()
        While ($rs.EOF -ne $True)
        {
                Write-Host "Ticket Nr.:" $rs.Fields.Item("job_ticket_id").Value
                Write-Host "  Subject:" $rs.Fields.Item("subject").Value
                Write-Host "  Opened:" $rs.Fields.Item("open_date").Value
                Write-Host "  Open in Minutes:" $rs.Fields.Item("open_for_minutes").Value
                Write-Host "  Client Name:" $rs.Fields.Item("first_name").Value $rs.Fields.Item("last_name").Value
                Write-Host "  Client eMail:" $rs.Fields.Item("email").Value
                Write-Host "  Client Phone:" $rs.Fields.Item("phone").Value
                Write-Host "  Tech Name:" $rs.Fields.Item("tech_first_name").Value $rs.Fields.Item("tech_last_name").Value
                Write-Host "  Problem Type:" $rs.Fields.Item("problem_type_name").Value
                Write-Host "  Priority:" $rs.Fields.Item("priority_type_name").Value
                Write-Host "  Slack User:" $rs.Fields.Item("phone_3").Value

                $DT = Date
                "$DT" + "|" + $rs.Fields.Item("job_ticket_id").Value | Add-Content NewTicketLog.txt

                $subject = $rs.Fields.Item("subject").Value 
                $subject = SlackCleanup($subject)

                $ticket = $rs.Fields.Item("job_ticket_id").Value
                $ticketlink = "https://helpdesk.YOURURL.com/helpdesk/WebObjects/Helpdesk.woa/wa/TicketActions/view?ticket=$ticket"

                $RequestDetail = $rs.Fields.Item("question_text").Value
                $RequestDetail = $RequestDetail.Trim()
                $RequestDetailLength = $RequestDetail.Length
                If ($RequestDetailLength -gt 500)
                {
                    $RequestDetailLength = 500
                }
                $RequestDetail = $RequestDetail.Substring(0,$RequestDetailLength)
                $RequestDetail = SlackCleanup($RequestDetail)

                $TicketDetails = "New:              " + $rs.Fields.Item("open_date").Value + "
New for:          " + $rs.Fields.Item("open_for_minutes").Value + " minutes
Tech Name:        " + $rs.Fields.Item("tech_first_name").Value + " " + $rs.Fields.Item("tech_last_name").Value + " @" + $rs.Fields.Item("phone_3").Value  + "
Client Name:      " + $rs.Fields.Item("first_name").Value + " " + $rs.Fields.Item("last_name").Value + "
Request Type:     " + $rs.Fields.Item("problem_type_name").Value + "
Priority:         " + $rs.Fields.Item("priority_type_name").Value + "
Client eMail:     " + $rs.Fields.Item("email").Value + "
Client Phone:     " + $rs.Fields.Item("phone").Value + "
Request Detail:   " + $RequestDetail

				.\PRTGSlackWebHookNotificationPSv2.ps1 -SlackWebHook 'https://hooks.slack.com/services/YOURWebHookURL' -SlackChannel $channel -SiteName 'HelpDesk' -Device $ticket -Name $subject -Status 'status' -Down 'down' -DateTime 'datetime' -LinkDevice $ticketlink -Message $TicketDetails -Color 'colorofstate'

            $rs.MoveNext();
        }
    }

$rs.Close()
$con.Close()

